<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Requests\LoginRequest;
use App\Http\Resources\UserResource;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    // POST /api/v1/login
    public function login(LoginRequest $request)
    {
        $user = User::where('email', $request->email)->first();

        if (! $user || ! Hash::check($request->password, $user->password)) {
            return response()->json(['message' => 'Invalid credentials'], 422);
        }
        if (! $user->is_active) {
            return response()->json(['message' => 'Account disabled'], 403);
        }

        $device = $request->string('device')->toString() ?: 'api';
        $token  = $user->createToken($device)->plainTextToken;

        // (optional) update last_login_at
        $user->forceFill(['last_login_at' => now()])->save();

        return response()->json([
            'token_type' => 'Bearer',
            'token'      => $token,
            'user'       => new UserResource($user),
        ], 200);
    }

    // POST /api/v1/logout  (revokes current token)
    public function logout(Request $request)
    {
        $request->user()?->currentAccessToken()?->delete();
        return response()->json(null, 204);
    }

    // POST /api/v1/logout-all  (revokes all tokens for this user)
    public function logoutAll(Request $request)
    {
        $request->user()?->tokens()->delete();
        return response()->json(null, 204);
    }

    // GET /api/v1/me
    public function me(Request $request)
    {
        return new UserResource($request->user());
    }
}
