<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreSettingRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        $userId = $this->user()->id ?? 0;

        return [
            'name'  => [
                'required','string','max:191',
                Rule::unique('settings','name')->where(fn($q) => $q->where('created_by', $userId)),
            ],
            // value can be string, number, bool, object, or array
            'value' => ['nullable'],
        ];
    }
}
