<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreUserRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'name'              => 'nullable|string|max:191',
            'email'             => 'required|email|max:191|unique:users,email',
            'password'          => 'required|string|min:8|max:191',
            'type'              => 'nullable|string|max:100',
            'plan'              => 'nullable|integer',
            'plan_expire_date'  => 'nullable|date',
            'requested_plan'    => 'nullable|integer',
            'storage_limit'     => 'nullable|numeric',
            'avatar'            => 'nullable|string|max:191',
            'messenger_color'   => 'nullable|string|max:191',
            'lang'              => 'nullable|string|max:100',
            'default_pipeline'  => 'nullable|integer',
            'active_status'     => 'nullable|boolean',
            'delete_status'     => 'nullable|integer',
            'mode'              => 'nullable|in:light,dark',
            'dark_mode'         => 'nullable|boolean',
            'is_active'         => 'nullable|boolean',
            'is_email_verified' => 'nullable|boolean',
            'email_verified_at' => 'nullable|date',
            'last_login_at'     => 'nullable|date',
            'created_by'        => 'nullable|integer',
        ];
    }
}
