<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateUserRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        $id = $this->route('user'); // route model binding (id or model)

        return [
            'name'              => 'sometimes|nullable|string|max:191',
            'email'             => ['sometimes','required','email','max:191', Rule::unique('users','email')->ignore($id)],
            'password'          => 'sometimes|nullable|string|min:8|max:191',
            'type'              => 'sometimes|nullable|string|max:100',
            'plan'              => 'sometimes|nullable|integer',
            'plan_expire_date'  => 'sometimes|nullable|date',
            'requested_plan'    => 'sometimes|nullable|integer',
            'storage_limit'     => 'sometimes|nullable|numeric',
            'avatar'            => 'sometimes|nullable|string|max:191',
            'messenger_color'   => 'sometimes|nullable|string|max:191',
            'lang'              => 'sometimes|nullable|string|max:100',
            'default_pipeline'  => 'sometimes|nullable|integer',
            'active_status'     => 'sometimes|nullable|boolean',
            'delete_status'     => 'sometimes|nullable|integer',
            'mode'              => 'sometimes|nullable|in:light,dark',
            'dark_mode'         => 'sometimes|nullable|boolean',
            'is_active'         => 'sometimes|nullable|boolean',
            'is_email_verified' => 'sometimes|nullable|boolean',
            'email_verified_at' => 'sometimes|nullable|date',
            'last_login_at'     => 'sometimes|nullable|date',
            'created_by'        => 'sometimes|nullable|integer',
        ];
    }
}
