<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
// REMOVE this if not used elsewhere:
// use Illuminate\Database\Eloquent\Casts\Attribute;

class User extends Authenticatable
{
    use HasApiTokens, Notifiable;

    protected $table = 'users';
    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = true;

    protected $fillable = [
        'name','email','password','plan','plan_expire_date','requested_plan','type',
        'storage_limit','avatar','messenger_color','lang','default_pipeline',
        'active_status','delete_status','mode','dark_mode','is_active','last_login_at',
        'created_by','is_email_verified','email_verified_at','remember_token',
    ];

    protected $hidden = ['password','remember_token'];

    protected $casts = [
        'plan_expire_date'  => 'date',
        'email_verified_at' => 'datetime',
        'last_login_at'     => 'datetime',
        'storage_limit'     => 'decimal:2',
        'active_status'     => 'boolean',
        'dark_mode'         => 'boolean',
        'is_active'         => 'boolean',
        'is_email_verified' => 'boolean',
    ];

    // Single, classic mutator (hash only when non-empty)
    public function setPasswordAttribute($value): void
    {
        if (is_string($value) && $value !== '') {
            $this->attributes['password'] = bcrypt($value);
        }
        // empty/null => keep existing hash
    }
}
